@extends('adminlte::page')

@section('title', 'Detail Grub')

@section('content')
<div class="container">
    <h3 class="mb-3">Detail Grub: {{ $grub->nama }}</h3>
    <div class="card shadow">
        <div class="card-body p-2">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped table-sm mb-0">
                <thead>
    <tr>
        <th>No</th>
        <th>Nama</th>
        <th>Penagih</th>
        <th>Alamat</th>
        <th>No HP</th>
        <th>Paket Wifi</th>
        <th>Status</th>
        <th>Status Tagihan</th>
        <!-- <th>Total Tunggakan (Rp)</th> Tambahan -->
        <th>Detail Tagihan</th>
    </tr>
</thead>
<tbody>
@foreach($grub->pelanggans as $pelanggan)
    @php
        $total_tunggakan = $pelanggan->pembayaran
            ->where('status', 'belum_lunas')
            ->sum(function($pembayaran) {
                return ($pembayaran->jumlah_tagihan - ($pembayaran->jumlah_dibayar ?? 0));
            });
    @endphp
    <tr>
        <td>{{ $loop->iteration }}</td>
        <td>{{ $pelanggan->nama }}</td>
        <td>{{ $pelanggan->penagih->name ?? '-' }}</td>
        <td>{{ $pelanggan->alamat }}</td>
        <td>{{ $pelanggan->no_hp }}</td>
        <td>{{ number_format($pelanggan->paket_wifi, 0, ',', '.') }}</td>
        <td>
            @if($pelanggan->status == 'suspend')
                <span class="badge badge-danger">Suspend</span>
            @else
                <span class="badge badge-success">Aktif</span>
            @endif
        </td>
        <td>
            @if($pelanggan->pembayaran->where('status', 'belum_lunas')->count() > 0)
                <span class="badge badge-warning text-dark">
                    Belum Lunas {{ $total_tunggakan > 0 ? number_format($total_tunggakan, 0, ',', '.') : '-' }}
                </span>
            @else
                <span class="badge badge-success">Lunas</span>
            @endif
        </td>
        <!--<td>
            {{ $total_tunggakan > 0 ? number_format($total_tunggakan, 0, ',', '.') : '-' }}
        </td>-->
        <td>
            <!-- Tombol Detail Tagihan, Edit, Suspend/Aktifkan -->
            <a href="{{ route('pelanggan.show', $pelanggan->id) }}" class="btn btn-info btn-xs">Detail Tagihan</a>
            <a href="{{ route('pelanggan.edit', $pelanggan->id) }}" class="btn btn-warning btn-xs">Edit</a>
            <input type="hidden" name="grub_id" value="{{ $pelanggan->grub_id }}">
            || &nbsp
            @if($pelanggan->status == 'aktif')
                <form method="POST" action="{{ route('pelanggan.suspend', $pelanggan->id) }}" style="display:inline;">
                @csrf
                    <button type="submit" class="btn btn-danger btn-xs" onclick="return confirm('Suspend pelanggan ini?')">Suspend</button>
                </form>
            @else
                <form method="POST" action="{{ route('pelanggan.aktifkan', $pelanggan->id) }}" style="display:inline;">
                @csrf
                    <button type="submit" class="btn btn-success btn-xs" onclick="return confirm('Aktifkan pelanggan?')">Aktifkan</button>
                </form>
            @endif
        </td>
    </tr>
@endforeach
</tbody>
                </table>
            </div>
            <div class="mt-2 mb-0">
                <a href="{{ route('pelanggan.index') }}" class="btn btn-secondary">Kembali</a>
            </div>
        </div>
    </div>
</div>
@endsection